
// __________________________________________________________
//
//                          ntqsi.c
//          ntdll.NtQuerySystemInformation Spy V1.00
//                10-24-1998 Sven B. Schreiber
//                       sbs@orgon.com
// __________________________________________________________

#include "ntqsi.h"

// =================================================================
// DISCLAIMER
// =================================================================

/*

This software is provided "as is" and any express or implied
warranties, including, but not limited to, the implied warranties of
merchantibility and fitness for a particular purpose are disclaimed.
In no event shall the author Sven B. Schreiber be liable for any
direct, indirect, incidental, special, exemplary, or consequential
damages (including, but not limited to, procurement of substitute
goods or services; loss of use, data, or profits; or business
interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software,
even if advised of the possibility of such damage.

*/

// =================================================================
// REVISION HISTORY
// =================================================================

/*

10-24-1998 V1.00 Original version (SBS).

*/

// =================================================================
// GLOBAL VARIABLES
// =================================================================

DWORD gdLine = 80;

// =================================================================
// GLOBAL STRINGS
// =================================================================

TBYTE atArguments [] =
    T("{ ")
    T("[+p|-p] ")
    T("[/<error limit>] ")
    T("[ <class> | [<class#1>]-[<class#n>] ]")
    T(" }\r\n\r\n")
    T("Options:   +p -p  Pointer relocation on/OFF\r\n")
    T("            /n    Quit after n consecutive errors\r\n")
    T("            x     Display info class #x\r\n")
    T("            x-y   Display info classes #x thru #y\r\n")
    T("            x-    Display info classes #x and up\r\n")
    T("             -y   Display info classes #0 thru #y\r\n")
    T("             -    Display info classes #0 and up\r\n\r\n")
    T("Examples:  ") S(MAIN_MODULE) T(" +p /10             ")
    T("Classes #0 and up, quit after 10 errors\r\n")
    T("           ") S(MAIN_MODULE) T(" +p 18 5 -p -3 6-8  ")
    T("Classes #18, #5, #0, #1, #2, #3, #6, #7, #8\r\n")
    T("           ") S(MAIN_MODULE) T(" /1 44-             ")
    T("Classes #44 and up, quit after first error");

// =================================================================
// DISPLAY ROUTINES
// =================================================================

BOOL WINAPI IsPointer (PBYTE pbData,
                       DWORD dSize,
                       DWORD dOffset)
    {
    PBYTE pbTarget;
    BOOL  fOk = FALSE;

    if ((!(dOffset & 0x03)) && (dOffset+4 <= dSize))
        {
        pbTarget = *(PPBYTE) (pbData+dOffset);
        fOk = ((pbTarget >= pbData) && (pbTarget < pbData+dSize));
        }
    return fOk;
    }

// -----------------------------------------------------------------

void WINAPI HexDump (PBYTE pbData1,
                     PBYTE pbData2,
                     DWORD dSize,
                     BOOL  fPointers)
    {
    DWORD dPointer, i, j;

    if (dSize)
        {
        printf (T("\r\nOffset| ")
                T("00 01 02 03 04 05 06 07 : ")
                T("08 09 0A 0B 0C 0D 0E 0F | ")
                T("01234567 : 89ABCDEF")
                T("\r\n------|-")
                T("------------------------:-")
                T("------------------------|-")
                T("---------:---------"));
        }
    for (dPointer = i = 0; i < dSize; i += j)
        {
        printf (T("\r\n%05lX"), i);

        for (j = 0; j < 0x10; j++)
            {
            if (!(j & 0x07))
                {
                printf (j & 0x0F ? T(" :") : T(" |"));
                }
            if (i+j < dSize)
                {
                if ((pbData1 [i+j] == TEST_PATTERN1) &&
                    (pbData2 [i+j] == TEST_PATTERN2))
                    {
                    printf (T(" --"));
                    }
                else
                    {
                    if (IsPointer (pbData1, dSize, i+j))
                        {
                        if (fPointers)
                            {
                            *(PPBYTE) (pbData1+i+j)
                                -= (DWORD) pbData1;
                            }
                        dPointer++;
                        }
                    printf (T("%c%02X"),
                            (dPointer > 1 ? '=' : ' '),
                            pbData1 [i+j]);

                    if (dPointer)
                        {
                        if (dPointer++ == 4) dPointer = 0;
                        }
                    }
                }
            else
                {
                printf (T("   "));
                }
            }
        for (j = 0; j < 0x10; j++)
            {
            if (!(j & 0x07))
                {
                printf (j & 0x0F ? T(" : ") : T(" | "));
                }
            if (i+j < dSize)
                {
                if ((pbData1 [i+j] == TEST_PATTERN1) &&
                    (pbData2 [i+j] == TEST_PATTERN2))
                    {
                    printf (T(" "));
                    }
                else
                    {
                    if ((pbData1 [i+j] >= 0x20) &&
                        (pbData1 [i+j] != 0x7F))
                        {
                        printf (T("%c"), pbData1 [i+j]);
                        }
                    else
                        {
                        printf (T("."));
                        }
                    }
                }
            else
                {
                printf (T(" "));
                }
            }
        }
    if (dSize) printf (T("\r\n"));
    return;
    }

// =================================================================
// INFO CLASS MANAGEMENT
// =================================================================

NTSTATUS WINAPI ReadInfoClass (SYSTEMINFOCLASS sic,
                               PBYTE           pbData,
                               PDWORD          pdSize,
                               BYTE            bPreset)
    {
    DWORD    dSize, i;
    NTSTATUS ns = STATUS_UNSUCCESSFUL;

    FillMemory (pbData, *pdSize, bPreset);

    for (i = *pdSize + 1; i; i--)
        {
        ns = NtQuerySystemInformation (sic, pbData, i-1, &dSize);

        if (ns != STATUS_INFO_LENGTH_MISMATCH) break;
        }
    if ((ns == STATUS_SUCCESS) && (!dSize))
        {
        for (i = 1; i < *pdSize + 1; i++)
            {
            ns = NtQuerySystemInformation (sic, pbData, i, NULL);
            dSize = i;

            if (ns != STATUS_INFO_LENGTH_MISMATCH) break;
            }
        }
    *pdSize = dSize;
    return ns;
    }

// -----------------------------------------------------------------

void WINAPI DisplayInfoClasses (DWORD dFirst,
                                DWORD dLast,
                                DWORD dLimit,
                                BOOL  fPointers)
    {
    NTSTATUS ns;
    PBYTE    pbData1, pbData2;
    DWORD    dSize1, dSize2, dErrors, i;

    if ((pbData1 = LocalAlloc (LMEM_FIXED, 2 * SYSTEM_INFO_BUFFER))
        != NULL)
        {
        pbData2 = pbData1 + SYSTEM_INFO_BUFFER;
        dErrors = 0;

        for (i = dFirst; i <= dLast; i++)
            {
            printf (T("\r\nNtQuerySystemInformation (%lu) "), i);

            dSize1 = SYSTEM_INFO_BUFFER;
            if ((ns = ReadInfoClass (i, pbData1, &dSize1,
                                     TEST_PATTERN1))
                == STATUS_SUCCESS)
                {
                dSize2 = SYSTEM_INFO_BUFFER;
                if ((ns = ReadInfoClass (i, pbData2, &dSize2,
                                         TEST_PATTERN2))
                    == STATUS_SUCCESS)
                    {
                    printf (T("--> %lu bytes"), dSize1);
                    if (!fPointers)
                        {
                        printf (T(" at 0x%08lX"), pbData1);
                        }
                    printf (T("\r\n"));

                    HexDump (pbData1, pbData2, dSize1, fPointers);
                    dErrors = 0;
                    }
                }
            if (ns != STATUS_SUCCESS)
                {
                printf (T("--> ERROR 0x%08lX\r\n"), ns);
                if (++dErrors == dLimit) break;
                }
            }
        LocalFree (pbData1);
        }
    return;
    }

// =================================================================
// COMMAND LINE PARSER
// =================================================================

DWORD WINAPI GetNumber (PTBYTE ptToken,
                        PDWORD pdOffset)
    {
    DWORD n = 0;

    while ((ptToken [*pdOffset] >= '0') &&
           (ptToken [*pdOffset] <= '9'))
        {
        n *= 10;
        n += (ptToken [(*pdOffset)++] - '0');
        }
    return n;
    }

// -----------------------------------------------------------------

BOOL WINAPI GetInfoClasses (PTBYTE ptToken,
                            PDWORD pdFirst,
                            PDWORD pdLast,
                            PDWORD pdLimit)
    {
    DWORD dFirst, dLast, dLimit, i;
    BOOL  fOk = FALSE;

    dFirst = 0;
    dLast  = MAXDWORD;
    dLimit = *pdLimit;

    i = 0;

    if (fOk = (ptToken [i++] != '/'))
        {
        if (ptToken [--i] != '-')
            {
            dFirst = GetNumber (ptToken, &i);
            }
        if (ptToken [i++] == '-')
            {
            if (ptToken [i])
                {
                dLast = GetNumber (ptToken, &i);
                }
            }
        else
            {
            dLast = dFirst;
            }
        }
    else
        {
        dLimit = GetNumber (ptToken, &i);
        }
    if (dFirst <= dLast)
        {
        *pdFirst = dFirst;
        *pdLast  = dLast;
        }
    else
        {
        *pdFirst = dLast;
        *pdLast  = dFirst;
        }
    *pdLimit = dLimit;
    return fOk;
    }

// =================================================================
// MAIN PROGRAM
// =================================================================

DWORD Main (DWORD argc, TBYTE *argv [], TBYTE *envp [])
    {
    CONSOLE_SCREEN_BUFFER_INFO csbi;
    DWORD                      dCodePage;
    DWORD                      dFirst, dLast, dLimit, i, j;
    BOOL                       fPointers;

    dCodePage = GetConsoleOutputCP ();
    SetConsoleOutputCP (GetACP ());
    GetConsoleScreenBufferInfo (hStdOut, &csbi);
    gdLine = csbi.dwSize.X;

    printf (atAbout);

    if (argc < 2)
        {
        printf (atUsage, atArguments);
        }
    else
        {
        dLimit = 0;

        for (i = 1, j = 0; i < argc; i++)
            {
            if (!lstrcmpi (argv [i], T("+p")))
                {
                fPointers = TRUE;
                }
            else if (!lstrcmpi (argv [i], T("-p")))
                {
                fPointers = FALSE;
                }
            else if (GetInfoClasses (argv [i],
                                     &dFirst, &dLast, &dLimit)
                     ||
                     ((i+1 == argc) && (!j)))
                {
                DisplayInfoClasses (dFirst, dLast, dLimit,
                                    fPointers);
                j++;
                }
            }
        }
    SetConsoleOutputCP (dCodePage);
    return 0;
    }

// =================================================================
// END OF PROGRAM
// =================================================================
